<?php

/**
 * Custom Post Type.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'LTY_Register_Post_Types' ) ) {

	/**
	 * LTY_Register_Post_Types Class.
	 * */
	class LTY_Register_Post_Types {

		/**
		 * Lottery Ticket Post Type.
		 * */
		const LOTTERY_TICKET_POSTTYPE = 'lty_lottery_ticket' ;

		/**
		 * Lottery Winner Post Type.
		 * */
		const LOTTERY_WINNER_POSTTYPE = 'lty_lottery_winner' ;

		/**
		 * Lottery Instant Winner Rules Post Type.
		 * 
		 * @since 8.0.0
		 * */
		const LOTTERY_INSTANT_WINNER_RULE_POSTTYPE = 'lty_instant_winners';

		/**
		 * Lottery instant winners log post type.
		 * 
		 * @since 8.0.0
		 * */
		const LOTTERY_INSTANT_WINNER_LOG_POSTTYPE = 'lty_ins_winner_log';

		/**
		 * LTY_Register_Post_Types Class initialization.
		 * */
		public static function init() {

			add_action( 'init', array( __CLASS__, 'register_custom_post_types' ) ) ;
		}

		/**
		 * Register Custom Post types.
		 * */
		public static function register_custom_post_types() {
			if ( ! is_blog_installed() ) {
				return ;
			}

			$custom_post_types = array(
				self::LOTTERY_TICKET_POSTTYPE => array( 'LTY_Register_Post_Types', 'lottery_ticket_post_type_args' ),
				self::LOTTERY_WINNER_POSTTYPE => array( 'LTY_Register_Post_Types', 'lottery_winner_post_type_args' ),
				self::LOTTERY_INSTANT_WINNER_RULE_POSTTYPE => array( 'LTY_Register_Post_Types', 'lottery_instant_winner_rule_post_type_args' ),
				self::LOTTERY_INSTANT_WINNER_LOG_POSTTYPE => array( 'LTY_Register_Post_Types', 'lottery_instant_winner_log_post_type_args' ),
				) ;

			/**
			 * This hook is used to alter the custom post types.
			 * 
			 * @since 1.0
			 */
			$custom_post_types = apply_filters( 'lty_add_custom_post_types', $custom_post_types ) ;

			// Return if no post type to register.
			if ( ! lty_check_is_array( $custom_post_types ) ) {
				return ;
			}

			foreach ( $custom_post_types as $post_type => $args_function ) {

				$args = array() ;
				if ( $args_function ) {
					$args = call_user_func_array( $args_function, $args ) ;
				}

				// Register custom post type.
				register_post_type( $post_type, $args ) ;
			}
		}

		/**
		 * Prepare Lottery Ticket Post type arguments.
		 * */
		public static function lottery_ticket_post_type_args() {
			/**
			 * This hook is used to alter the lottery ticket post type arguments.
			 * 
			 * @since 1.0
			 */
			return apply_filters(
					'lty_lottery_ticket_post_type_args', array(
				'label'           => __( 'Lottery Ticket', 'lottery-for-woocommerce' ),
				'public'          => false,
				'hierarchical'    => false,
				'supports'        => false,
				'capability_type' => 'post',
				'rewrite'         => false,
					)
					) ;
		}

		/**
		 * Prepare Lottery Winner Post type arguments.
		 * */
		public static function lottery_winner_post_type_args() {
			/**
			 * This hook is used to alter the lottery winner post type arguments.
			 * 
			 * @since 1.0
			 */
			return apply_filters(
					'lty_lottery_winner_post_type_args', array(
				'label'           => __( 'Lottery Winner', 'lottery-for-woocommerce' ),
				'public'          => false,
				'hierarchical'    => false,
				'supports'        => false,
				'capability_type' => 'post',
				'rewrite'         => false,
					)
					) ;
		}

		/**
		 * Prepare Lottery Instant Winner rule Post Type arguments.
		 * 
		 * @since 8.0.0
		 * */
		public static function lottery_instant_winner_rule_post_type_args() {
			/**
			 * This hook is used to alter the instant winner rule post type args.
			 * 
			 * @since 8.0.0
			 */
			return apply_filters(
					'lty_lottery_instant_winners_prizes_post_type_args', array(
				'label'         => __('Lottery Instant Winners Prizes', 'lottery-for-woocommerce'),
				'public'            => false,
				'hierarchical'      => false,
				'supports'      => false,
				'capability_type'   => 'post',
				'rewrite'           => false,
					)
			);
		}
		
		/**
		 * Prepare lottery instant winner log post type arguments.
		 * 
		 * @since 8.0.0
		 * */
		public static function lottery_instant_winner_log_post_type_args() {
			/**
			 * This hook is used to alter the instant winner log post type args.
			 * 
			 * @since 8.0.0
			 */
			return apply_filters(
					'lty_lottery_instant_winner_log_post_type_args', array(
				'label'         => __('Lottery Instant Winner Log', 'lottery-for-woocommerce'),
				'public'        => false,
				'hierarchical'  => false,
				'supports'      => false,
				'capability_type'=> 'post',
				'rewrite'       => false,
					)
			);
		}
	}

	LTY_Register_Post_Types::init() ;
}
