<?php
/**
 * Lottery instant winners rules.
 *
 * @since 9.5.0
 * @var object $product Product object.
 * @var array $instant_winner_ids Instant winner IDs.
 * @var int $current_page Current page.
 * @var int $page_count Page count.
 * @var int $items_per_page Number of items per page.
 * */
defined('ABSPATH') || exit; // Exit if accessed directly.
?>
<div class='lty-instant-winners-rules-wrapper show_if_lottery'>
	<p><b><?php esc_html_e('Note: ', 'lottery-for-woocommerce'); ?></b><?php esc_html_e("If you make any changes in instant win fields, then please save the instant win settings using 'Save' button. If you don't save the instant win settings, the changes will not reflect.", 'lottery-for-woocommerce'); ?></p>
	<button type='button' class='lty-import-popup lty-import-instant-winner-rule-btn button-primary' 
			data-action='instant-winner-rule' data-extra_data='<?php echo wp_json_encode(array( 'product_id' => $product->get_id() )); ?>'>
			<?php esc_html_e( 'Import', 'lottery-for-woocommerce' ); ?></button>
	<button type='button' class='button lty-export-instant-winner-rules lty-export-popup button-primary' data-export_type='instant_winner_rules' data-extra_data="<?php echo esc_attr( wp_json_encode( array( 'product_id' => $product->get_id() ) ) ); ?>"><?php esc_html_e( 'Export', 'lottery-for-woocommerce' ); ?></button>
	<?php require LTY_ABSPATH . 'inc/admin/menu/views/html-lottery-instant-winners-rules-actions.php'; ?>
	<table class='lty-instant-winners-rules-contents wp-list-table widefat striped'>
		<thead>
			<tr>
				<th><input type='checkbox' class='lty-select-all-instant-winners-rules' title="<?php esc_html_e('Select All', 'lottery-for-woocommerce'); ?>"></th>
				<th><b><?php esc_html_e('Image', 'lottery-for-woocommerce'); ?></b></th>
				<th><b><?php esc_html_e('Ticket Number', 'lottery-for-woocommerce'); ?></b></th>
				<th><b><?php esc_html_e('Prize Type', 'lottery-for-woocommerce'); ?></b></th>
				<th><b><?php esc_html_e('Prize', 'lottery-for-woocommerce'); ?></b></th>
				<th><b><?php esc_html_e('Action', 'lottery-for-woocommerce'); ?></b></th>
			</tr>
		</thead>
		<tbody>
			<?php
			if (lty_check_is_array($instant_winner_ids)) :
				foreach ($instant_winner_ids as $rule_id) :
					$instant_winner = lty_get_instant_winner_rule($rule_id);
					if (!is_object($instant_winner)) :
						continue;
					endif;
					$name = 'lty_instant_winner_rules[' . $rule_id . ']';
					?>
					<tr>
						<td>
							<input type='checkbox' name='lty_select_instant_winner_rule' class='lty-select-instant-winner-rule' />
							<br>
							<small>
								<b><?php esc_html_e('ID: ', 'lottery-for-woocommerce'); ?></b><?php echo esc_html($rule_id); ?>
							</small>
						</td>
						<td>
							<p class='lty-instant-winner-image-preview'>
								<img src="<?php echo esc_url( $instant_winner->get_image_url() ); ?>" height='45px' width='45px' />
							</p>
							<input type='hidden' name="<?php echo esc_attr( $name ); ?>[image_id]" class='lty-instant-winner-image-id' value="<?php echo esc_attr( $instant_winner->get_image_id() ); ?>"/>
							<span class='dashicons dashicons-upload lty-instant-winner-rule lty-select-image' title="<?php esc_attr_e( 'Choose Image', 'lottery-for-woocommerce' ); ?>" ></span>
							<span class='dashicons dashicons-trash lty-instant-winner-rule lty-remove-image' title="<?php esc_attr_e( 'Remove', 'lottery-for-woocommerce' ); ?>" style="<?php echo empty( $instant_winner->get_image_id() ) ? 'display: none;' : ''; ?>" ></span>
						</td>
						<td><input type='text' class='lty-instant-winner-rule lty-ticket-number' name="<?php echo esc_attr($name); ?>[ticket_number]" value="<?php echo wp_kses_post($instant_winner->get_ticket_number()); ?>"></td>
						<td>
							<p>
								<select name="<?php echo esc_attr( $name ); ?>[prize_type]" class='lty-instant-winner-rule lty-instant-winner-prize-type'>
									<?php foreach ( lty_get_instant_winner_prize_type_options() as $option_key => $option_label ) : ?>	
										<option value="<?php echo esc_attr( $option_key ); ?>" <?php selected( $option_key, $instant_winner->get_prize_type(), true ); ?> ><?php echo esc_html( $option_label ); ?></option>
									<?php endforeach; ?>
								</select>
							</p>
							<p>
								<select name="<?php echo esc_attr( $name ); ?>[coupon_generation_type]" class='lty-instant-winner-rule lty-instant-winner-prize-field lty-instant-winner-coupon-generation-type'>
									<?php foreach ( lty_get_instant_winner_coupon_generation_type_options() as $option_key => $option_label ) : ?>	
										<option value="<?php echo esc_attr( $option_key ); ?>" <?php selected( $option_key, $instant_winner->get_coupon_generation_type(), true ); ?>><?php echo esc_html( $option_label ); ?></option>
									<?php endforeach; ?>
								</select>
							</p>
							<p>
								<select name="<?php echo esc_attr( $name ); ?>[coupon_discount_type]" class='lty-instant-winner-rule lty-instant-winner-prize-field lty-instant-winner-coupon-field lty-instant-winner-coupon-discount-type'>
									<?php foreach ( lty_get_instant_winner_coupon_discount_type_options() as $option_key => $option_label ) : ?>	
										<option value="<?php echo esc_attr( $option_key ); ?>" <?php selected( $option_key, $instant_winner->get_coupon_discount_type(), true ); ?>><?php echo esc_html( $option_label ); ?></option>
									<?php endforeach; ?>
								</select>
							</p>
							<p>
								<?php
								lty_select2_html(
									array(
										'id'          => $name . '[coupon_id]',
										'class'       => 'lty-instant-winner-rule lty-instant-winner-prize-field lty-instant-winner-coupon-field lty-instant-winner-coupon-id',
										'action'      => 'lty_json_search_coupons',
										'placeholder' => __( 'Search for a coupon&hellip;', 'lottery-for-woocommerce' ),
										'multiple'    => false,
										'options'     => array( $instant_winner->get_coupon_id() ),
									)
								);
								?>
							</p>
							<p>
								<input type='text' class='wc_input_price lty-instant-winner-rule lty-instant-winner-prize-field lty-instant-winner-coupon-field lty-instant-winner-prize-amount' name="<?php echo esc_attr( $name ); ?>[prize_amount]" value="<?php echo wp_kses_post( $instant_winner->get_prize_amount() ); ?>">
							</p>
						</td>
						<td>
							<textarea class='lty-instant-winner-rule lty-instant-winner-prize-message' name="<?php echo esc_attr( $name ); ?>[prize_message]"><?php echo wp_kses_post( $instant_winner->get_prize_message() ); ?></textarea>
						</td>
						<td><span class='lty-remove-instant-winner-rule dashicons dashicons-dismiss' data-instant_winner_rule_id='<?php echo esc_attr($rule_id); ?>' title="<?php esc_html_e('Remove rule', 'lottery-for-woocommerce'); ?>"></span></td>
					</tr>
					<?php
				endforeach;
			else :
				?>
				<tr>
					<td colspan='5'><?php esc_html_e('Click the "Add New Rule" Button to create new Instant Winner rule', 'lottery-for-woocommerce'); ?></td>
				</tr>
			<?php endif; ?>
		</tbody>
		<input type='hidden' class='lty-product-id' value="<?php echo esc_attr($product->get_id()); ?>"/>
		<input type='hidden' class='lty-per-page' value="<?php echo esc_attr($items_per_page); ?>" />
	</table>
	<?php require LTY_ABSPATH . 'inc/admin/menu/views/html-lottery-instant-winners-rules-actions.php'; ?>
	<input type='hidden' class='lty-unsaved-instant-winner-rules' value=''/>
</div>
<?php

