jQuery(function ($) {
    'use strict';
    const numbersSelected = [];
    const restApiBaseUrl = base_url + '/wp-json/arka-custom-lottery-extension/v1/products';
    //const restApiBaseUrl = 'https://arka.design/rifa/wp-json/arka-custom-lottery-extension/v1/products';
    var CustomLotterySelector = {
        init: function () {
// Select the ticket.
            $(document).on('click tap', '.lty-ticket', this.lottery_ticket_selection);
            $(document).on('click tap', '.lty-selected-ticket', this.lottery_ticket_unselection);
        },
        lottery_ticket_selection: function (event) {
            event.preventDefault();
            var $this = $(event.currentTarget);

            const indexTicket = numbersSelected.findIndex(item => item.ticket === $this.data('ticket'));
            if (indexTicket >= 0 ||$this.hasClass("lty-booked-ticket") || $this.hasClass("lty-processing-ticket"))
                return

            $.ajax({
                type: 'GET',
                dataType: 'JSON',
                url: `${restApiBaseUrl}/generateNumbers/${post_id_object.post_id}?ticket=${$this.data('ticket')}`,
                success: function (response) {
                    const numbersSelectedData = [];
                    numbersSelected.push({
                        ticket: $this.data('ticket'),
                        numbers: response
                    });

                    let selectedNumbersString = '';
                    for (let i = 0; i < response.length; i++) {
                        selectedNumbersString += ` ${response[i].number}`;

                        if (i < response.length - 1) {
                            selectedNumbersString += ', ';
                        }
                    }

                    selectedNumbersString = `${$($this).data('ticket')}: [${selectedNumbersString}]`;
                    const parentElement = $('#custom-tickets-selected').find('.elementor-spacer-inner');
                    if (parentElement.children('ul').length > 0) {
                        parentElement.children('ul').append(`<li data-id="${$($this).data('ticket')}">${selectedNumbersString}</li>`);
                    } else {
                        parentElement.append(`<ul><li data-id="${$($this).data('ticket')}">${selectedNumbersString}</li></ul>`);
                    }

                    parentElement.children('ul').css('list-style', 'none');
                }
            });
        },
        lottery_ticket_unselection: function (event) {
            event.preventDefault();
            var $this = $(event.currentTarget);
            const parentElement = $('#custom-tickets-selected').find('.elementor-spacer-inner');

            const indexTicket = numbersSelected.findIndex(item => item.ticket === $this.data('ticket'));
            if (indexTicket >= 0) {
                //numbersSelected.push($this.data('ticket'));
                //remove from numbersSelected
                console.log(numbersSelected[indexTicket]);
                $.ajax({
                    type: 'POST',
                    contentType : 'application/json',
                    dataType: 'JSON',
                    url: `${restApiBaseUrl}/enable-numbers/${post_id_object.post_id}`,
                    data: JSON.stringify(numbersSelected[indexTicket]),
                    success: function (response) {
                        //event to remove data
                        parentElement.children('ul').children(`li[data-id="${$this.data('ticket')}"]`).remove();
                        numbersSelected.splice(indexTicket, 1);
                    }
                });
            }
        }
    };
    CustomLotterySelector.init();
});
