<?php
/**
 * Plugin Name: ArkaCustomLotteryExtension
 * Plugin URI:
 * Description: Plugin to add sort for selected tickets
 * Version: 0.1
 * Author: Gustavo Canul
 * Author URI:
 **/


if (!function_exists('enqueue_custom_code_script')) {
    function enqueue_custom_code_script(): void
    {
        global $post;
        wp_register_script('custom-lottery-selector', '/wp-content/plugins/arka-custom-lottery-extension/assets/js/index.js', array('jquery'), '3.7.1', true);
        wp_enqueue_script('custom-lottery-selector');
        wp_localize_script('custom-lottery-selector', 'post_id_object', array('post_id' => $post->ID));
        wp_localize_script('custom-lottery-selector', 'base_url', get_home_url());
    }
}


add_action('wp_enqueue_scripts', 'enqueue_custom_code_script');

if (!function_exists('create_numbers_selections_table')) {
    function create_numbers_selections_table(): void
    {
        global $wpdb;
        $charset_collate = $wpdb->get_charset_collate();

        $table_name = $wpdb->prefix . 'lottery_selections';

        $sql = "CREATE TABLE " . $table_name . " (
	id int(11) NOT NULL AUTO_INCREMENT,
	number integer NOT NULL,
	status ENUM('AVAILABLE','SELECTED', 'PAID') NOT NULL,
	date_selected DATETIME NOT NULL,
	ticket_number int(11) NOT NULL,
	post_id int(11) NOT NULL,
	PRIMARY KEY  (id)
    ) $charset_collate;";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
}
register_activation_hook(__FILE__, 'create_numbers_selections_table');

include 'controllers/rest-api.php';
include 'controllers/custom-cart-content.php';